<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--This simply pulls in the name and unit for every class in
     the ancestor list-->


<xsl:template name="hierarchy">
<hierarchy>
    <xsl:call-template name = "recursivehierarchy"/>
</hierarchy>
</xsl:template>

<xsl:template name = "recursivehierarchy">

    <xsl:for-each select="./ancestor">
        <xsl:variable name="namespaceTest" select="@namespace"/>
        <ancestor>
            <xsl:if test="contains($namespaceTest, 'Borland')">
                <xsl:attribute name="docset">borland</xsl:attribute>
            </xsl:if>
            <xsl:if test="not(contains($namespaceTest, 'Borland'))">
                <xsl:attribute name="docset">microsoft</xsl:attribute>
            </xsl:if>
            <namespace>
                <xsl:value-of select="@namespace"/>
            </namespace>
            <class>
                <xsl:value-of select="@name"/>
            </class>
        </ancestor>
        <xsl:call-template name = "recursivehierarchy"/>
    </xsl:for-each>
        
</xsl:template>

</xsl:stylesheet>
